package de.ecconia.java.pnet.stream;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;

import de.ecconia.java.pnet.exceptions.NetworkException;
import de.ecconia.java.pnet.exceptions.NetworkException.ClosingNetworkException;
import de.ecconia.java.pnet.exceptions.NetworkException.DisconnectedException;
import de.ecconia.java.pnet.exceptions.NetworkException.EndOfStreamException;
import de.ecconia.java.pnet.exceptions.NetworkException.UffConnectionResetException;
import de.ecconia.java.pnet.exceptions.NetworkException.UnknownNetworkException;

public class StreamReader implements Reader
{
	private final InputStream is;
	
	public StreamReader(InputStream is)
	{
		this.is = is;
	}
	
	public byte readByte() throws NetworkException
	{
		try
		{
			int i = is.read();
			
			if(i == -1)
			{
				throw new EndOfStreamException();
			}
			
			return (byte) i;
		}
		catch(IOException e)
		{
			//TODO: Find (more) cases!
			if(e instanceof SocketException)
			{
				if("Connection reset".equals(e.getMessage()))
				{
					throw new DisconnectedException();
				}
			}
			
			throw new UnknownNetworkException(e);
		}
	}
	
	public byte[] readBytes(int amount) throws NetworkException
	{
		try
		{
			byte[] bytes = new byte[amount];
			
			int pointer = 0;
			int remaining = amount;
			
			while(remaining > 0)
			{
				int amountRead = is.read(bytes, pointer, remaining);
				if(amountRead < 0)
				{
					throw new EndOfStreamException();
				}
				
				remaining -= amountRead;
				pointer += amountRead;
				
				//TODO: Remove debug.
				if(remaining > 0) //Happens when wrong length provided...
				{
					System.out.println("[Debug/StreamReader] While reading " + amount + " still " + remaining + " left.");
				}
			}
			
			return bytes;
		}
		catch(IOException e)
		{
			if(e instanceof SocketException)
			{
				if("Socket closed".equals(e.getMessage()))
				{
					throw new ClosingNetworkException();
				}
				else if("Connection reset".equals(e.getMessage()))
				{
					throw new UffConnectionResetException();
				}
			}
			
			//TODO: Find cases!
			throw new UnknownNetworkException(e);
		}
	}
}
