package de.ecconia.java.pnet.misc;

public class IntTools
{
	public static final int BYTES = Integer.BYTES;
	
	public static byte[] intToBytes(int value)
	{
		byte[] array = new byte[BYTES];
		
		for(int i = 0; i < BYTES; i++)
		{
			array[i] = (byte) (value & 255);
			value = value >> 8;
		}
		
		return array;
	}
	
	public static int bytesToInt(byte[] bytes)
	{
		int value = 0;
		int shift = 0;
		
		for(int i = 0; i < BYTES; i++, shift += 8)
		{
			int tmp = bytes[i] & 255;
			tmp = tmp << shift;
			value |= tmp;
		}
		
		return value;
	}
}
