package de.ecconia.java.pnet.stream;

import de.ecconia.java.pnet.encryption.SyncCryptUnit;
import de.ecconia.java.pnet.exceptions.NetworkException;

public class DecryptionReader implements Reader
{
	private final Reader reader;
	private final SyncCryptUnit cripter;
	
	public DecryptionReader(Reader reader, SyncCryptUnit cripter)
	{
		this.reader = reader;
		this.cripter = cripter;
	}
	
	@Override
	public byte readByte() throws NetworkException
	{
		return cripter.decryptByte(reader.readByte());
	}
	
	@Override
	public byte[] readBytes(int amount) throws NetworkException
	{
		return cripter.decryptBytes(reader.readBytes(amount));
	}
}
