package de.ecconia.java.pnet.exceptions;

@SuppressWarnings("serial")
public abstract class NetworkException extends Exception
{
	public NetworkException(Throwable t)
	{
		super(t);
	}
	
	public NetworkException()
	{
	}
	
	//Subexceptions:
	
	public static class ClosingNetworkException extends NetworkException
	{
	}
	
	public static class DisconnectedException extends NetworkException
	{
	}
	
	public static class EndOfStreamException extends NetworkException
	{
	}
	
	public static class ConnectionResetException extends NetworkException
	{
	}
	
	public static class ConnectionTimeoutException extends NetworkException
	{
	}
	
	public static class UnknownNetworkException extends NetworkException
	{
		public UnknownNetworkException(Throwable t)
		{
			super(t);
			
			//If this exception is thrown, this framework can be enhanced, by adding a specific exception.
			System.err.println("Unknown IOException has been found. Please report it.");
			t.printStackTrace();
		}
	}
}
