package de.ecconia.java.pnet.encryption;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

import de.ecconia.java.pnet.exceptions.CipherException;

public class HashTools
{
	public static String generateHashSHA1(byte[]... bytePacks)
	{
		try
		{
			MessageDigest digest = MessageDigest.getInstance("SHA-1");
			for(byte[] bytes : bytePacks)
			{
				digest.update(bytes);
			}
			return new BigInteger(digest.digest()).toString(16);
		}
		catch(NoSuchAlgorithmException e)
		{
			throw new CipherException(e);
		}
	}
}
