/*
 * Decompiled with CFR 0.152.
 */
package de.ecconia.java.pnet.stream;

import de.ecconia.java.pnet.exceptions.NetworkException;
import de.ecconia.java.pnet.stream.Reader;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;

public class StreamReader
implements Reader {
    private final InputStream is;

    public StreamReader(InputStream is) {
        this.is = is;
    }

    @Override
    public byte readByte() throws NetworkException {
        try {
            int i = this.is.read();
            if (i < 0) {
                throw new NetworkException.EndOfStreamException();
            }
            return (byte)i;
        }
        catch (IOException e) {
            if (e instanceof SocketException && "Connection reset".equals(e.getMessage())) {
                throw new NetworkException.DisconnectedException();
            }
            throw new NetworkException.UnknownNetworkException(e);
        }
    }

    @Override
    public byte[] readBytes(int amount) throws NetworkException {
        try {
            byte[] bytes = new byte[amount];
            int pointer = 0;
            int remaining = amount;
            while (remaining > 0) {
                int amountRead = this.is.read(bytes, pointer, remaining);
                if (amountRead < 0) {
                    throw new NetworkException.EndOfStreamException();
                }
                remaining -= amountRead;
                pointer += amountRead;
            }
            return bytes;
        }
        catch (IOException e) {
            if (e instanceof SocketException) {
                if ("Socket closed".equals(e.getMessage())) {
                    throw new NetworkException.ClosingNetworkException();
                }
                if ("socket closed".equals(e.getMessage())) {
                    throw new NetworkException.ClosingNetworkException();
                }
                if ("Connection reset".equals(e.getMessage())) {
                    throw new NetworkException.ConnectionResetException();
                }
            }
            throw new NetworkException.UnknownNetworkException(e);
        }
    }
}

