/*
 * Decompiled with CFR 0.152.
 */
package de.ecconia.java.pnet.encryption;

import de.ecconia.java.pnet.exceptions.CipherException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class SyncCryptUnit {
    private final Cipher decryptCipher;
    private final Cipher encryptCipher;

    public SyncCryptUnit(SecretKey key) {
        try {
            this.decryptCipher = Cipher.getInstance("AES/CFB8/NoPadding");
            this.decryptCipher.init(2, (Key)key, new IvParameterSpec(key.getEncoded()));
            this.encryptCipher = Cipher.getInstance("AES/CFB8/NoPadding");
            this.encryptCipher.init(1, (Key)key, new IvParameterSpec(key.getEncoded()));
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new CipherException(e);
        }
    }

    public byte decryptByte(byte b) {
        return this.decryptBytes(new byte[]{b})[0];
    }

    public byte[] decryptBytes(byte[] bytes) {
        byte[] o = new byte[this.decryptCipher.getOutputSize(bytes.length)];
        try {
            this.decryptCipher.update(bytes, 0, bytes.length, o, 0);
            return o;
        }
        catch (ShortBufferException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] encryptBytes(byte[] bytes) {
        byte[] o = new byte[this.encryptCipher.getOutputSize(bytes.length)];
        try {
            this.encryptCipher.update(bytes, 0, bytes.length, o, 0);
            return o;
        }
        catch (ShortBufferException e) {
            throw new RuntimeException(e);
        }
    }

    public static SecretKey secredKeyFromBytes(byte[] bytes) {
        return new SecretKeySpec(bytes, "AES");
    }

    public static SecretKey generateKey(int bits) {
        try {
            KeyGenerator gen = KeyGenerator.getInstance("AES");
            gen.init(bits);
            return gen.generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw new CipherException(e);
        }
    }
}

