package de.ecconia.java.pnet.encryption;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;

import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

import de.ecconia.java.pnet.exceptions.CipherException;

public class AsyncCryptTools
{
	public static PublicKey bytesToPublicKey(byte[] pubkeyBytes)
	{
		try
		{
			return KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(pubkeyBytes));
		}
		catch(InvalidKeySpecException | NoSuchAlgorithmException e)
		{
			throw new CipherException(e);
		}
	}
	
	public static byte[] encryptBytes(PublicKey publicKey, byte[] encoded)
	{
		try
		{
			Cipher cipher = Cipher.getInstance(publicKey.getAlgorithm().equals("RSA") ? "RSA/ECB/PKCS1Padding" : "AES/CFB8/NoPadding");
			cipher.init(Cipher.ENCRYPT_MODE, publicKey);
			return cipher.doFinal(encoded);
		}
		catch(InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException | IllegalBlockSizeException | BadPaddingException e)
		{
			throw new CipherException(e);
		}
	}
	
	public static byte[] decryptBytes(Key key, byte[] bytes)
	{
		try
		{
			Cipher cipher = Cipher.getInstance(key.getAlgorithm());
			cipher.init(Cipher.DECRYPT_MODE, key);
			return cipher.doFinal(bytes);
		}
		catch(NoSuchAlgorithmException | NoSuchPaddingException | InvalidKeyException | IllegalBlockSizeException | BadPaddingException e)
		{
			throw new CipherException(e);
		}
	}
	
	public static KeyPair generateKeyPair(int length)
	{
		try
		{
			KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
			generator.initialize(length);
			return generator.generateKeyPair();
		}
		catch(NoSuchAlgorithmException e)
		{
			throw new CipherException(e);
		}
	}
}
