/*
 * Decompiled with CFR 0.152.
 */
package de.ecconia.java.json.token;

import de.ecconia.java.json.token.JSONTokenIterator;
import de.ecconia.java.json.token.JSONType;
import java.util.ArrayList;

public class JSONToken {
    private final JSONType type;
    private Character content;

    private JSONToken(JSONType type, char content) {
        this.type = type;
        this.content = Character.valueOf(content);
    }

    private JSONToken(JSONType type) {
        this.type = type;
    }

    public Character getContent() {
        return this.content;
    }

    public JSONType getType() {
        return this.type;
    }

    public String toString() {
        return this.type.name() + (this.content != null ? "<" + this.content + ">" : "");
    }

    public static JSONTokenIterator parse(String s, boolean debug) {
        ArrayList<JSONToken> tokens = new ArrayList<JSONToken>();
        boolean inQuote = false;
        boolean nextEscapted = false;
        boolean thisEscaped = false;
        block10: for (char c : s.toCharArray()) {
            if (inQuote) {
                thisEscaped = false;
                if (nextEscapted) {
                    thisEscaped = true;
                    nextEscapted = false;
                } else if (c == '\\') {
                    nextEscapted = true;
                }
                if (!thisEscaped && c == '\"') {
                    tokens.add(new JSONToken(JSONType.QUOTE));
                    inQuote = false;
                    continue;
                }
                tokens.add(new JSONToken(JSONType.TEXT, c));
                continue;
            }
            switch (c) {
                case ':': {
                    tokens.add(new JSONToken(JSONType.PAIR_SEPARATOR));
                    continue block10;
                }
                case '{': {
                    tokens.add(new JSONToken(JSONType.OBJECT_OPEN));
                    continue block10;
                }
                case '}': {
                    tokens.add(new JSONToken(JSONType.OBJECT_CLOSE));
                    continue block10;
                }
                case '[': {
                    tokens.add(new JSONToken(JSONType.ARRAY_OPEN));
                    continue block10;
                }
                case ']': {
                    tokens.add(new JSONToken(JSONType.ARRAY_CLOSE));
                    continue block10;
                }
                case ',': {
                    tokens.add(new JSONToken(JSONType.SEPARATOR));
                    continue block10;
                }
                case '\t': 
                case '\n': 
                case ' ': {
                    tokens.add(new JSONToken(JSONType.SPACE, c));
                    continue block10;
                }
                case '\"': {
                    inQuote = true;
                    tokens.add(new JSONToken(JSONType.QUOTE));
                    continue block10;
                }
                default: {
                    tokens.add(new JSONToken(JSONType.UNKNOWN, c));
                    continue block10;
                }
            }
        }
        return new JSONTokenIterator(tokens, debug);
    }
}

