/*
 * Decompiled with CFR 0.152.
 */
package de.ecconia.java.json;

import de.ecconia.java.json.JSONArray;
import de.ecconia.java.json.JSONNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class JSONObject
extends JSONNode {
    private final Map<String, Object> entries = new HashMap<String, Object>();

    public void put(String key, Object obj) {
        this.entries.put(key, obj);
    }

    public Object get(String key) {
        return this.entries.get(key);
    }

    public Map<String, Object> getEntries() {
        return this.entries;
    }

    @Override
    public String printJSON() {
        String tmp = "";
        Iterator<Map.Entry<String, Object>> it = this.entries.entrySet().iterator();
        if (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            tmp = tmp + '\"' + entry.getKey() + "\":" + JSONObject.printJSON(entry.getValue());
            while (it.hasNext()) {
                entry = it.next();
                tmp = tmp + ",\"" + entry.getKey() + "\":" + JSONObject.printJSON(entry.getValue());
            }
        }
        return '{' + tmp + '}';
    }

    @Override
    public void debugTree(String prefix) {
        System.out.println('{');
        String innerPrefix = prefix + "\u00b7   ";
        for (Map.Entry<String, Object> entry : this.entries.entrySet()) {
            String key = entry.getKey().replace("\n", "\\n");
            Object obj = entry.getValue();
            System.out.print(innerPrefix + "\"" + key + "\": ");
            if (obj == null) {
                System.out.println("null");
                continue;
            }
            if (obj instanceof Boolean) {
                System.out.println(obj);
                continue;
            }
            if (obj instanceof Number) {
                System.out.println(obj);
                continue;
            }
            if (obj instanceof String) {
                System.out.println("\"" + ((String)obj).replace("\n", "\\n") + "\"");
                continue;
            }
            JSONNode node = (JSONNode)obj;
            node.debugTree(innerPrefix);
        }
        System.out.println(prefix + "}");
    }

    public JSONObject getObject(String key) {
        return JSONObject.asObject(this.entries.get(key));
    }

    public JSONArray getArray(String key) {
        return JSONObject.asArray(this.entries.get(key));
    }

    public String getString(String key) {
        return JSONObject.asString(this.entries.get(key));
    }

    public boolean getBool(String key) {
        return JSONObject.asBool(this.entries.get(key));
    }

    public long getLong(String key) {
        return JSONObject.asLong(this.entries.get(key));
    }

    public int getInt(String key) {
        return JSONObject.asInt(this.entries.get(key));
    }

    public short getShort(String key) {
        return JSONObject.asShort(this.entries.get(key));
    }

    public byte getByte(String key) {
        return JSONObject.asByte(this.entries.get(key));
    }

    public double getDouble(String key) {
        return JSONObject.asDouble(this.entries.get(key));
    }

    public float getFloat(String key) {
        return JSONObject.asFloat(this.entries.get(key));
    }

    public JSONObject getObjectOrNull(String key) {
        Object object = this.entries.get(key);
        if (object == null) {
            return null;
        }
        return JSONObject.asObject(object);
    }

    public JSONArray getArrayOrNull(String key) {
        Object object = this.entries.get(key);
        if (object == null) {
            return null;
        }
        return JSONObject.asArray(object);
    }

    public String getStringOrNull(String key) {
        Object object = this.entries.get(key);
        if (object == null) {
            return null;
        }
        return JSONObject.asString(object);
    }

    public Boolean getBoolOrNull(String key) {
        Object object = this.entries.get(key);
        if (object == null) {
            return null;
        }
        return JSONObject.asBool(object);
    }

    public Long getLongOrNull(String key) {
        Object object = this.entries.get(key);
        if (object == null) {
            return null;
        }
        return JSONObject.asLong(object);
    }

    public Integer getIntOrNull(String key) {
        Object object = this.entries.get(key);
        if (object == null) {
            return null;
        }
        return JSONObject.asInt(object);
    }

    public Short getShortOrNull(String key) {
        Object object = this.entries.get(key);
        if (object == null) {
            return null;
        }
        return JSONObject.asShort(object);
    }

    public Byte getByteOrNull(String key) {
        Object object = this.entries.get(key);
        if (object == null) {
            return null;
        }
        return JSONObject.asByte(object);
    }

    public Double getDoubleOrNull(String key) {
        Object object = this.entries.get(key);
        if (object == null) {
            return null;
        }
        return JSONObject.asDouble(object);
    }

    public Float getFloatOrNull(String key) {
        Object object = this.entries.get(key);
        if (object == null) {
            return null;
        }
        return Float.valueOf(JSONObject.asFloat(object));
    }
}

