/*
 * Decompiled with CFR 0.152.
 */
package de.ecconia.java.json;

import de.ecconia.java.json.JSONArray;
import de.ecconia.java.json.JSONGetException;
import de.ecconia.java.json.JSONObject;
import java.math.BigDecimal;

public abstract class JSONNode {
    public abstract void debugTree(String var1);

    public abstract String printJSON();

    protected static String printJSON(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof Boolean) {
            return o.toString();
        }
        if (o instanceof JSONNode) {
            return ((JSONNode)o).printJSON();
        }
        if (o instanceof Number) {
            if (o instanceof Double) {
                return new BigDecimal((Double)o).toString();
            }
            if (o instanceof Float) {
                return new BigDecimal(((Float)o).floatValue()).toString();
            }
            return o.toString();
        }
        return "\"" + JSONNode.escapeString(o.toString()) + "\"";
    }

    private static String escapeString(String s) {
        s = s.replace("\\", "\\\\");
        s = s.replace("\"", "\\\"");
        s = s.replace("/", "\\/");
        s = s.replace("\b", "\\b");
        s = s.replace("\f", "\\f");
        s = s.replace("\n", "\\n");
        s = s.replace("\r", "\\r");
        s = s.replace("\t", "\\t");
        return s;
    }

    protected static String unescapeString(String s) {
        s = s.replace("\b", "\\b");
        s = s.replace("\f", "\\f");
        s = s.replace("\n", "\\n");
        s = s.replace("\r", "\\r");
        s = s.replace("\t", "\\t");
        s = s.replace("/", "\\/");
        s = s.replace("\"", "\\\"");
        s = s.replace("\\", "\\\\");
        return s;
    }

    public static JSONObject asObject(Object object) {
        if (object == null) {
            throw new JSONGetException("Key not present.");
        }
        if (!(object instanceof JSONObject)) {
            throw new JSONGetException("Value of type '" + object.getClass().getSimpleName() + "' instead of JSONObject");
        }
        return (JSONObject)object;
    }

    public static JSONArray asArray(Object object) {
        if (object == null) {
            throw new JSONGetException("Key not present.");
        }
        if (!(object instanceof JSONArray)) {
            throw new JSONGetException("Value of type '" + object.getClass().getSimpleName() + "' instead of JSONArray");
        }
        return (JSONArray)object;
    }

    public static String asString(Object object) {
        if (object == null) {
            throw new JSONGetException("Key not present.");
        }
        if (!(object instanceof String)) {
            throw new JSONGetException("Value of type '" + object.getClass().getSimpleName() + "' instead of String");
        }
        return (String)object;
    }

    public static boolean asBool(Object object) {
        if (object == null) {
            throw new JSONGetException("Key not present.");
        }
        if (!(object instanceof Boolean)) {
            throw new JSONGetException("Value of type '" + object.getClass().getSimpleName() + "' instead of Boolean");
        }
        return (Boolean)object;
    }

    public static byte asByte(Object object) {
        if (object == null) {
            throw new JSONGetException("Key not present.");
        }
        if (!(object instanceof Number)) {
            throw new JSONGetException("Value of type '" + object.getClass().getSimpleName() + "' instead of Number");
        }
        return ((Number)object).byteValue();
    }

    public static short asShort(Object object) {
        if (object == null) {
            throw new JSONGetException("Key not present.");
        }
        if (!(object instanceof Number)) {
            throw new JSONGetException("Value of type '" + object.getClass().getSimpleName() + "' instead of Number");
        }
        return ((Number)object).shortValue();
    }

    public static int asInt(Object object) {
        if (object == null) {
            throw new JSONGetException("Key not present.");
        }
        if (!(object instanceof Number)) {
            throw new JSONGetException("Value of type '" + object.getClass().getSimpleName() + "' instead of Number");
        }
        return ((Number)object).intValue();
    }

    public static long asLong(Object object) {
        if (object == null) {
            throw new JSONGetException("Key not present.");
        }
        if (!(object instanceof Number)) {
            throw new JSONGetException("Value of type '" + object.getClass().getSimpleName() + "' instead of Number");
        }
        return ((Number)object).longValue();
    }

    public static double asDouble(Object object) {
        if (object == null) {
            throw new JSONGetException("Key not present.");
        }
        if (!(object instanceof Number)) {
            throw new JSONGetException("Value of type '" + object.getClass().getSimpleName() + "' instead of Number");
        }
        return ((Number)object).doubleValue();
    }

    public static float asFloat(Object object) {
        if (object == null) {
            throw new JSONGetException("Key not present.");
        }
        if (!(object instanceof Number)) {
            throw new JSONGetException("Value of type '" + object.getClass().getSimpleName() + "' instead of Number");
        }
        return ((Number)object).floatValue();
    }
}

