/*
 * Decompiled with CFR 0.152.
 */
package de.ecconia.java.json;

import de.ecconia.java.json.JSONNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class JSONObject
extends JSONNode {
    private final Map<String, Object> entries = new HashMap<String, Object>();

    public void put(String key, Object obj) {
        this.entries.put(key, obj);
    }

    public Object get(String key) {
        return this.entries.get(key);
    }

    public Map<String, Object> getEntries() {
        return this.entries;
    }

    @Override
    public String printJSON() {
        String tmp = "";
        Iterator<Map.Entry<String, Object>> it = this.entries.entrySet().iterator();
        if (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            tmp = String.valueOf(tmp) + '\"' + entry.getKey() + "\":" + JSONObject.printJSON(entry.getValue());
            while (it.hasNext()) {
                entry = it.next();
                tmp = String.valueOf(tmp) + ",\"" + entry.getKey() + "\":" + JSONObject.printJSON(entry.getValue());
            }
        }
        return String.valueOf('{') + tmp + '}';
    }

    @Override
    public void debugTree(String prefix) {
        System.out.println('{');
        String innerPrefix = String.valueOf(prefix) + "\u00b7   ";
        for (Map.Entry<String, Object> entry : this.entries.entrySet()) {
            String key = entry.getKey().replace("\n", "\\n");
            Object obj = entry.getValue();
            System.out.print(String.valueOf(innerPrefix) + "\"" + key + "\": ");
            if (obj == null) {
                System.out.println("null");
                continue;
            }
            if (obj instanceof Boolean) {
                System.out.println(obj);
                continue;
            }
            if (obj instanceof Number) {
                System.out.println(obj);
                continue;
            }
            if (obj instanceof String) {
                System.out.println("\"" + ((String)obj).replace("\n", "\\n") + "\"");
                continue;
            }
            JSONNode node = (JSONNode)obj;
            node.debugTree(innerPrefix);
        }
        System.out.println(String.valueOf(prefix) + "}");
    }
}

