/*
 * Decompiled with CFR 0.152.
 */
package de.ecconia.java.json;

import java.math.BigDecimal;

public abstract class JSONNode {
    public abstract void debugTree(String var1);

    public abstract String printJSON();

    protected static String printJSON(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof Boolean) {
            return o.toString();
        }
        if (o instanceof JSONNode) {
            return ((JSONNode)o).printJSON();
        }
        if (o instanceof Number) {
            if (o instanceof Double) {
                return new BigDecimal((Double)o).toString();
            }
            if (o instanceof Float) {
                return new BigDecimal(((Float)o).floatValue()).toString();
            }
            return o.toString();
        }
        return "\"" + JSONNode.escapeString(o.toString()) + "\"";
    }

    private static String escapeString(String s) {
        s = s.replace("\\", "\\\\");
        s = s.replace("\"", "\\\"");
        s = s.replace("/", "\\/");
        s = s.replace("\b", "\\b");
        s = s.replace("\f", "\\f");
        s = s.replace("\n", "\\n");
        s = s.replace("\r", "\\r");
        s = s.replace("\t", "\\t");
        return s;
    }

    protected static String unescapeString(String s) {
        s = s.replace("\b", "\\b");
        s = s.replace("\f", "\\f");
        s = s.replace("\n", "\\n");
        s = s.replace("\r", "\\r");
        s = s.replace("\t", "\\t");
        s = s.replace("/", "\\/");
        s = s.replace("\"", "\\\"");
        s = s.replace("\\", "\\\\");
        return s;
    }
}

